/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.common.entity.projectile.Pebble;
import dev.toma.gunsrpg.common.init.ModEntities;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.util.locate.ammo.ItemLocator;
import java.util.IdentityHashMap;
import java.util.Map;
import lib.toma.animations.Easings;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;

public class SlingItem
extends BaseItem {
    public SlingItem(String name) {
        super(name, new Item.Properties().func_200916_a(ModTabs.ITEM_TAB).func_200918_c(130));
    }

    public ActionResult<ItemStack> func_77659_a(World level, PlayerEntity player, Hand hand) {
        boolean hasAmmo;
        ItemStack stack = player.func_184586_b(hand);
        boolean bl = hasAmmo = player.func_184812_l_() || ItemLocator.contains((IInventory)player.field_71071_by, AmmoRegistry::isValidAmmo);
        if (hasAmmo) {
            player.func_184598_c(hand);
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entity;
        ItemLocator.consume((IInventory)player.field_71071_by, AmmoRegistry::isValidAmmo, ctx -> {
            ItemStack ammoStack = ctx.getCurrectStack();
            boolean hasAmmo = !ammoStack.func_190926_b() || player.func_184812_l_();
            int pullTime = this.func_77626_a(stack) - timeLeft;
            if (pullTime < 0 || !hasAmmo) {
                return;
            }
            float power = SlingItem.getPowerForTime(pullTime);
            if ((double)power < 0.75) {
                return;
            }
            if (!world.field_72995_K) {
                Pebble pebble = new Pebble((EntityType<? extends Pebble>)((EntityType)ModEntities.PEBBLE.get()), world, entity);
                int damage = AmmoRegistry.getDamage(ammoStack);
                if (damage == 0 && player.func_184812_l_()) {
                    damage = 4;
                }
                pebble.setup((float)damage * power, power * 1.75f, 0);
                pebble.fire(player.field_70125_A, player.field_70177_z, 0.5f);
                pebble.setAmmoSource(ammoStack.func_190926_b() ? new ItemStack((IItemProvider)ModItems.SMALL_STONE) : ammoStack.func_77946_l());
                world.func_217376_c((Entity)pebble);
                if (!player.func_184812_l_()) {
                    stack.func_222118_a(1, (LivingEntity)player, playerArg -> playerArg.func_213334_d(player.func_184600_cs()));
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + power * 0.5f);
            if (!player.func_184812_l_()) {
                ammoStack.func_190918_g(1);
            }
        });
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    private static float getPowerForTime(int time) {
        float rawPower = (float)time / 11.0f;
        return rawPower >= 1.0f ? 1.0f : Easings.EASE_OUT_QUAD.ease((rawPower - 0.75f) / 0.25f);
    }

    public static void initAmmoRegistry() {
        AmmoRegistry.register(ModItems.SMALL_STONE, 3);
        AmmoRegistry.register(Items.field_191525_da, 4);
        AmmoRegistry.register(Items.field_151074_bl, 5);
    }

    public static final class AmmoRegistry {
        private static final Map<Item, Integer> DAMAGE_TABLE = new IdentityHashMap<Item, Integer>();

        public static void register(Item item, int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("Damage must be bigger than 0");
            }
            DAMAGE_TABLE.put(item, value);
        }

        public static int getDamage(ItemStack stack) {
            return DAMAGE_TABLE.getOrDefault(stack.func_77973_b(), 0);
        }

        public static boolean isValidAmmo(ItemStack stack) {
            return DAMAGE_TABLE.containsKey(stack.func_77973_b());
        }
    }
}

